//
//  MusicChunker.h
//  wavedisc
//
//  Created by zan on 15/11/2018.
//  Copyright © 2018 zan. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AudioToolbox/AudioToolbox.h>
@interface MusicChunker : NSObject
{
    AudioFileID audioFile;
    int _sampleRate;
    int _totalFrames;
    UInt64 _framesPerPacket;
    UInt64 _totalPackets;
    UInt64 fileDataSize;
    AudioFilePacketTableInfo _packetInfo;
    int _fileLength;
    AudioStreamBasicDescription _fileDataFormat;
    NSFileHandle * _fileHandle;
    int _packetOffset;
    int _totalReadBytes;
    int _maxPacketSize;
    BOOL firstTime;
    BOOL _ism4a;
}
-(id)initWithURL:(NSURL*)url andFileType:(NSString*)ext;
//gets next chunk that corresponds to seconds of audio
-(NSData*)getNextDataChunk:(int)seconds;
-(int)getChannelNumber;
-(int)getSampleRate;
-(int)getTotalFrame;

@end
