//
//  BUNView.m
//  wavedisc
//
//  Created by zan on 16/10/2018.
//  Copyright © 2018 zan. All rights reserved.
//

#import "BUNView.h"

@implementation BUNView
@synthesize minFreq, maxFreq, rps, steps, chromatic, rep, radius;

-(void)awakeFromNib {
    self.maxFreq = 200;
    self.maxFreq = 2000;
    self.rps = 6;
    self.steps = 12;
    self.radius = 150.0;
    self.chromatic = NO;
}

-(double)frequencyFromNote:(int)note {
    return 1.0*130.813 * pow(1.0594630943593, note);
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];
    if(self.rep != nil) {
        
        int W = (int)(self.rep.pixelsWide);
        int H = (int)(self.rep.pixelsHigh);
        
        CIImage * img = [[CIImage alloc] initWithCGImage:[self.rep CGImage]];
        
        CIFilter * incline = [CIFilter filterWithName:@"CIPerspectiveTransform"];
        [incline setValue:img forKey:@"inputImage"];
        [incline setValue:[CIVector vectorWithX:0 Y:H] forKey:@"inputTopLeft"];
        [incline setValue:[CIVector vectorWithX:W Y:H+1] forKey:@"inputTopRight"];
        [incline setValue:[CIVector vectorWithX:W Y:1] forKey:@"inputBottomRight"];
        [incline setValue:[CIVector vectorWithX:0 Y:0] forKey:@"inputBottomLeft"];
        img = [incline valueForKey:@"outputImage"];
        
        img = [img imageByCroppingToRect:NSMakeRect(0, 0, W, H)];
        
        CIFilter * wrap = [CIFilter filterWithName:@"CICircularWrap"];
        CIVector * center = [CIVector vectorWithX:0 Y:0];
        [wrap setValue:img forKey:@"inputImage"];
        [wrap setValue:center forKey:@"inputCenter"];
        [wrap setValue:@(radius) forKey:@"inputRadius"];
        [wrap setValue:@(0) forKey:@"inputAngle"];
        img = [wrap valueForKey:@"outputImage"];
        
        NSBitmapImageRep * rep2 = [[NSBitmapImageRep alloc] initWithCIImage:img];
        //[[rep TIFFRepresentation] writeToFile:@"/Users/zan/Desktop/qq.tif" atomically:YES];
        
        [[NSGraphicsContext currentContext] setImageInterpolation:NSImageInterpolationHigh];
        [rep2 drawInRect:self.bounds];
    }
    else {
        [NSGraphicsContext saveGraphicsState];
        
        NSAffineTransform * tr = [NSAffineTransform transform];
        [tr translateXBy:self.bounds.size.width/2 yBy:self.bounds.size.height/2];
        [tr concat];
        
        float intRadius = MIN(self.bounds.size.width/2, self.bounds.size.height/2)/8;
        float extRadius = MIN(self.bounds.size.width/2, self.bounds.size.height/2);
        float intFreq = self.minFreq;
        float extFreq = self.maxFreq;
        int ringCount = self.steps;
        float width = (extRadius - intRadius)/ringCount;
        
        [[NSBezierPath bezierPathWithOvalInRect:NSMakeRect(-1, -1, 2, 2)] stroke];
        
        for(int ring = 0 ; ring < ringCount ; ring++) {
            
            double radius = intRadius + ((double)ring/(double)ringCount)*(extRadius - intRadius);
            double freq = 0;
            if (self.chromatic) {
                freq = [self frequencyFromNote:ring+12];
            } else {
                freq = intFreq +((double)ring/(double)ringCount)*(extFreq - intFreq);
            }
            double spatialFreq = round(freq/self.rps);
            double angularStep = 2.0*M_PI / spatialFreq;
            double rand = 2*M_PI*(double)(arc4random_uniform(3600))/3600;
            
            for(int f = 0 ; f < spatialFreq ; f++) {
                
                double a = f*angularStep + rand;
                
                NSBezierPath * path = [NSBezierPath bezierPath];
                [path moveToPoint:NSMakePoint((radius+width) * cos(a+angularStep/4), (radius+width) * sin(a+angularStep/4))];
                [path lineToPoint:NSMakePoint(radius * cos(a+angularStep/4), radius * sin(a+angularStep/4))];
                [path appendBezierPathWithArcWithCenter:NSMakePoint(0, 0) radius:radius startAngle:180*(a+angularStep/4)/M_PI endAngle:180*(a-angularStep/4)/M_PI clockwise:YES];
                [path lineToPoint:NSMakePoint((radius + width) * cos(a-angularStep/4), (radius + width) * sin(a-angularStep/4))];
                [path appendBezierPathWithArcWithCenter:NSMakePoint(0, 0) radius:radius+width startAngle:180*(a-angularStep/4)/M_PI endAngle:180*(a+angularStep/4)/M_PI clockwise:NO];
                [path closePath];
                [path fill];
            }
        }
        
        [NSGraphicsContext restoreGraphicsState];
    }
}

@end
