//
//  AppDelegate.m
//  wavedisc
//
//  Created by zan on 16/10/2018.
//  Copyright © 2018 zan. All rights reserved.
//

#import "AppDelegate.h"

@interface AppDelegate ()

@property (weak) IBOutlet NSWindow *window;
@end

@implementation AppDelegate

-(BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)sender {
    return YES;
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
    
    [self extractAudioFile:@"/Users/zan/Desktop/ELECTRO/SCANNER/chopin.wav"];
 }

-(void)extractAudioFile:(NSString*)p {
    chunker = [[MusicChunker alloc] initWithURL:[NSURL URLWithString:p] andFileType:@"wav"];
    NSData * data = [chunker getNextDataChunk:80];

    int channelCount = [chunker getChannelNumber];
    NSLog(@"Data raw size %d", (int)(data.length));
    NSLog(@"Sample rate %d", [chunker getSampleRate]);
    NSLog(@"Total frames %d", [chunker getTotalFrame]);
    NSLog(@"Channel count %d", channelCount);
    int secs = (float)[chunker getTotalFrame] / (float)[chunker getSampleRate];
    int mins = floor(secs / 60);
    secs = secs - (mins*60);
    NSLog(@"duration %d min %d s", mins, secs);
    
    
    //SInt16*bytes;
    //bytes = (SInt16*)malloc(data.length * sizeof(SInt16));
    
    SInt16 bytes[data.length];
    
    [data getBytes:&bytes length:data.length*sizeof(SInt16)];
    
    // tps = 6 tr/sec et une portion de disque entre 20 mm et 320mm du centre, 10 secondes = 60 tours, largeur sillon = 150/60 = 2.5mm
    // vitesse de défillement à R = 20 mm = 6 * 2 * PI * 20 = 754 mm/s      >> ±754 Hz avec une résolution spatiale de 1mm
    // vitesse de défillement à R = 160 mm = 6 * 2 * PI * 160 = 6030 mm/s   >> ±6 KHz avec une résolution spatiale de 1mm
    
    // ou à tps = 20 tr/s et R = 150 mm on obtient 18849 Hz avec 1 marque par mm

    
    int N = (int)(data.length) / sizeof(*bytes) / channelCount;  // divide by two for stereo
    
    int lpf = 2;
    int N_lpf = N / lpf;
    
    int W = 3366;
    int H = N / W + 1;
    
    NSLog(@"image %d x %d = %dpx for %d samples or 20 sec at 44100Hz", W,H, W*H, N);
    
    NSBitmapImageRep * rep = [[NSBitmapImageRep alloc] initWithBitmapDataPlanes:NULL
                                                                     pixelsWide:W
                                                                     pixelsHigh:H
                                                                  bitsPerSample:8
                                                                samplesPerPixel:4
                                                                       hasAlpha:YES
                                                                       isPlanar:NO
                                                                 colorSpaceName:NSDeviceRGBColorSpace
                                                                    bytesPerRow:W*4
                                                                   bitsPerPixel:32];
    for(int i=0 ; i < N_lpf ;i++){
        NSInteger d = 127 + floor(127*(bytes[i*channelCount*lpf] / 32768.0f)); // i*2 for stereo (interlaced channels)
        NSUInteger pixel[4] = {d,d,d,255};
        [rep setPixel:pixel atX:i%W y:floor(H-(i/W))];
    }
    [[rep TIFFRepresentation] writeToFile:@"/Users/zan/Desktop/tests.tif" atomically:YES];
    view.rep = rep;
    [view setNeedsDisplay:YES];
}

-(IBAction)setRadius:(NSSlider*)sld {
    view.radius = sld.doubleValue;
    [view setNeedsDisplay:YES];
}


-(IBAction)chooseAudioFile:(NSButton*)btn {
   

        NSOpenPanel * panel = [NSOpenPanel openPanel];
        [panel setCanChooseFiles:YES];
        [panel setCanChooseDirectories:NO];
        [panel setAllowsMultipleSelection:NO];
        NSString *path;
        if ([panel runModal] == NSModalResponseOK)
        {
            path = [[panel URL] path];
            [self extractAudioFile:path];
        }
    
}

-(void)windowDidEndLiveResize:(NSNotification *)notification {
    [view setNeedsDisplay:YES];
}

-(IBAction)save:(id)sender {
    
    NSData * pdfData = [view dataWithPDFInsideRect:view.bounds];
    NSString * path = [NSHomeDirectory() stringByAppendingPathComponent:@"/Desktop/wave.pdf"];
    
    BOOL success = [pdfData writeToFile:path atomically:YES];
    
    
    NSLog(@"%@", success ? @"pdf written" :  @"can't write pdf");
    
}

-(IBAction)setMinFreq:(NSTextField*)txtf {
    view.minFreq = [txtf doubleValue];
    [view setNeedsDisplay:YES];
}
-(IBAction)setMaxFreq:(NSTextField*)txtf {
    view.maxFreq = [txtf doubleValue];
    [view setNeedsDisplay:YES];
}
-(IBAction)setRps:(NSTextField*)txtf {
    view.rps = [txtf doubleValue];
    [view setNeedsDisplay:YES];
}
-(IBAction)setSteps:(NSTextField*)txtf {
    view.steps = [txtf intValue];
    [view setNeedsDisplay:YES];
}

-(IBAction)setChromatic:(NSButton*)btn {
    view.chromatic = btn.state;
    [view setNeedsDisplay:YES];
    if (btn.state) {
        [minFreq setEnabled:NO];
        [maxFreq setEnabled:NO];
        [minFreq setEditable:NO];
        [maxFreq setEditable:NO];
        [minFreq setSelectable:NO];
        [maxFreq setSelectable:NO];
    } else {
        [minFreq setEnabled:YES];
        [maxFreq setEnabled:YES];
        [minFreq setEditable:YES];
        [maxFreq setEditable:YES];
        [minFreq setSelectable:YES];
        [maxFreq setSelectable:YES];
    }
}
@end
