//
//  BUNView.h
//  Refraction
//
//  Created by minibun on 31/12/2015.
//  Copyright (c) 2015 minibun. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Quartz/Quartz.h>
#import "BUNLens.h"

@interface BUNView : NSView
{
    double N_air;
    double N_glass;
    
    NSPoint target;
    NSPoint source;
    BOOL catchTarget;
    BOOL catchSource;
    
    NSColor * rayColor;
    
    NSMutableArray * rays;
    NSMutableArray * lenses;
    
    double scale;
    double ec;
    double lastEc;
}

@property (strong) NSMutableArray * rays;
@property (strong) NSMutableArray * lenses;
@property (strong) BUNLens * lens1;
@property int rayMode;


-(void)reset;
-(void)setScale:(double)s;
-(void)setEcart:(double)ee;
-(void)updateRays;
@end
