//
//  BUNLens.m
//  Refraction
//
//  Created by minibun on 02/01/2016.
//  Copyright (c) 2016 minibun. All rights reserved.
//

#import "BUNLens.h"
#import "BUNRay.h"




@implementation BUNLens
@synthesize r1;
@synthesize r2;
@synthesize h1,h2;
@synthesize ep;
@synthesize x;
@synthesize y;
@synthesize n;
@synthesize dispersion;
@synthesize shape;
@synthesize selected;


-(id)init {
    self = [super init];
    if (self != nil) {
        return self;
        selected = NO;
    }
    return nil;
}

- (id)initWithCoder:(NSCoder *)decoder {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    self.r1 = [[decoder decodeObjectForKey:@"r1"] doubleValue];
    self.r2 = [[decoder decodeObjectForKey:@"r2"] doubleValue];
    self.h1 = [[decoder decodeObjectForKey:@"h1"] doubleValue];
    self.h2 = [[decoder decodeObjectForKey:@"h2"] doubleValue];
    self.ep = [[decoder decodeObjectForKey:@"ep"] doubleValue];
    self.x = [[decoder decodeObjectForKey:@"x"] doubleValue];
    self.y = [[decoder decodeObjectForKey:@"y"] doubleValue];
    self.n = [[decoder decodeObjectForKey:@"n"] doubleValue];
    self.dispersion = [[decoder decodeObjectForKey:@"dispersion"] doubleValue];
    self.selected = [[decoder decodeObjectForKey:@"selected"] boolValue];
    self.shape = [decoder decodeObjectForKey:@"shape"];
    
    return self;
}

- (void)encodeWithCoder:(NSCoder *)encoder {
    [encoder encodeObject:[NSNumber numberWithDouble:self.r1] forKey:@"r1"];
    [encoder encodeObject:[NSNumber numberWithDouble:self.r2] forKey:@"r2"];
    [encoder encodeObject:[NSNumber numberWithDouble:self.h1] forKey:@"h1"];
    [encoder encodeObject:[NSNumber numberWithDouble:self.h2] forKey:@"h2"];
    [encoder encodeObject:[NSNumber numberWithDouble:self.ep] forKey:@"ep"];
    [encoder encodeObject:[NSNumber numberWithDouble:self.x] forKey:@"x"];
    [encoder encodeObject:[NSNumber numberWithDouble:self.y] forKey:@"y"];
    [encoder encodeObject:[NSNumber numberWithDouble:self.n] forKey:@"n"];
    [encoder encodeObject:[NSNumber numberWithDouble:self.dispersion] forKey:@"dispersion"];
    [encoder encodeObject:[NSNumber numberWithBool:self.selected] forKey:@"selected"];
    [encoder encodeObject:self.shape forKey:@"shape"];
}


- (id)copyWithZone:(NSZone *)zone
{
    BUNLens * copy = [[BUNLens alloc] init];
    
    if (copy)
    {
        // Copy NSObject subclasses
        copy.r1 = self.r1;
        copy.r2 = self.r2;
        copy.h1 = self.h1;
        copy.h2 = self.h2;
        copy.ep = self.ep;
        copy.x = self.x;
        copy.y = self.y;
        copy.n = self.n;
        
        copy.dispersion = self.dispersion;
        copy.selected = self.selected;
        copy.shape = self.shape;        
    }
    
    return copy;
}

-(double)ox1
{
    return x-ep + r1;
}

-(double)ox2
{
    return x+ep + r2;
}

-(void)makeShape
{
    self.shape = [NSBezierPath bezierPath];

    double ox1 = x-ep + r1;
    double ox2 = x+ep + r2;
    
    double angle1 = 180*asin(h1/ABS(self.r1))/M_PI;
    double angle2 = 180*asin(h2/ABS(self.r2))/M_PI;
    
    if (isnan(angle1) || isnan(angle2))
    {
        return;
    }
    
    [shape appendBezierPathWithArcWithCenter:NSMakePoint(ox1, y)
                                      radius:ABS(self.r1)
                                  startAngle:(1- 2*(r1>=0))*angle1 + (r1>=0? 180 : 0)
                                    endAngle:-(1- 2*(r1>=0))*angle1+ (r1>=0? 180 : 0)
                                   clockwise:r1<0];
    
    [shape appendBezierPathWithArcWithCenter:NSMakePoint(ox2, y)
                                      radius:ABS(self.r2)
                                  startAngle:-(1- 2*(r2>=0))*angle2 + (r2>=0? 180 : 0)
                                    endAngle:(1- 2*(r2>=0))*angle2 + (r2>=0? 180 : 0)
                                   clockwise:r2>=0];
    
    [self.shape closePath];
    
    
}

-(BOOL)containsPoint:(NSPoint)pt
{
    if ([self.shape containsPoint:pt])
    {
        //selected = !selected;
        return YES;
    }
    return  NO;
}

@end
