//
//  BUNView.m
//  Refraction
//
//  Created by minibun on 31/12/2015.
//  Copyright (c) 2015 minibun. All rights reserved.
//

#import "BUNView.h"
#import "BUNRay.h"
#import "BUNLens.h"
#import "AppDelegate.h"

@implementation BUNView

@synthesize lens1;
@synthesize lenses;
@synthesize rays;
@synthesize rayMode;

-(void)reset
{
    scale = 1;
    ec = 4;
    lastEc = 4;
    source = NSMakePoint(50, self.frame.size.height/2);
    target = NSMakePoint(self.frame.size.width/2, self.frame.size.height/2);
    rayMode = 0;
    

    if ([[NSUserDefaults standardUserDefaults] dataForKey:@"lenses"])
    {
        NSData * data = [[NSUserDefaults standardUserDefaults] dataForKey:@"lenses"];
        lenses = [NSKeyedUnarchiver unarchiveObjectWithData:data];
    }
    
    else
    {
        lenses = [NSMutableArray array];
        
        BUNLens * lens11 = [[BUNLens alloc] init];
        lens11.r1 = 300;
        lens11.r2 = -10000;
        lens11.x = 180;
        lens11.y = self.frame.size.height/2;
        lens11.h1 = 200;
        lens11.h2 = 130;
        lens11.ep = 50;
        lens11.n = 1.5;
        lens11.selected = YES;
        lens11.dispersion = 0.01;
        [lens11 makeShape];
        [lenses addObject:lens11];
        
        BUNLens * lens2 = [[BUNLens alloc] init];
        lens2.r1 = -1000;
        lens2.r2 = 500;
        lens2.x = 370;
        lens2.y = self.frame.size.height/2;
        lens2.h1 = 150;
        lens2.h2 = 130;
        lens2.ep = 15;
        lens2.n = 1.8;
        lens2.dispersion = 0.05;
        [lens2 makeShape];
        [lenses addObject:lens2];
        
        BUNLens * lens3 = [[BUNLens alloc] init];
        lens3.r1 = 10000;
        lens3.r2 = 500;
        lens3.x = 500;
        lens3.y = self.frame.size.height/2;
        lens3.h1 = 130;
        lens3.h2 = 130;
        lens3.n = 1.5;
        lens3.dispersion = 0.01;
        lens3.ep = 15   ;
        [lens3 makeShape];
        [lenses addObject:lens3];
        
        BUNLens * lens4 = [[BUNLens alloc] init];
        lens4.r1 = 500;
        lens4.r2 = -500;
        lens4.x = 550;
        lens4.y = self.frame.size.height/2;
        lens4.h1 = 130;
        lens4.h2 = 130;
        lens4.n = 1.8;
        lens4.dispersion = 0.05;
        lens4.ep = 30;
        [lens4 makeShape];
        [lenses addObject:lens4];
        
        self.lens1 = lens11;
        [(AppDelegate*)[NSApp delegate] setUIWithLens:lens11];
    }
    
    rays = [NSMutableArray array];
    for (int i = 0 ; i < 11; i++)
    {
        BUNRay * ray = [[BUNRay alloc] init];
        ray.lenses = lenses;
        ray.startX = 10;
        ray.startY = self.frame.size.height/2;
        ray.startAngle = 0;
        ray.hue = 0.5;//(double)i/7.0;
        [rays addObject:ray];
    }
    [self setNeedsDisplay:YES];
}


- (void)drawRect:(NSRect)dirtyRect
{
    [super drawRect:dirtyRect];
    [[NSColor blackColor] set];
    NSRectFill(dirtyRect);
    
    [[NSColor darkGrayColor] set];
    [[NSBezierPath bezierPathWithRect:NSMakeRect(0, self.frame.size.height/2, self.frame.size.width, 2)] fill];
    
    NSGraphicsContext *ctx =[NSGraphicsContext currentContext];
    [ctx saveGraphicsState];
    NSAffineTransform * trans = [NSAffineTransform  transform];
    [trans translateXBy:self.frame.size.width/2 yBy:self.frame.size.height/2];
    [trans scaleBy:scale];
    [trans translateXBy:-self.frame.size.width/2 yBy:-self.frame.size.height/2];
    [trans concat];
    
    for (BUNLens * l in lenses)
    {
        if (l == self.lens1)
        {
            [[NSColor colorWithCalibratedRed:1 green:0.7 blue:0 alpha:1] setStroke];
            [[NSColor colorWithCalibratedRed:1 green:0.7 blue:0 alpha:0.6] setFill];
            [self.lens1.shape fill];
            [self.lens1.shape stroke];

        }
        else
        {
            if (l.selected)
            {
                [[NSColor colorWithCalibratedRed:1 green:0.7 blue:0 alpha:0.7] setStroke];
                [[NSColor colorWithCalibratedRed:1 green:0.7 blue:0 alpha:0.3] setFill];
            }
            else
            {
                [[NSColor grayColor] setStroke];
                [[NSColor colorWithCalibratedWhite:1 alpha:0.2] setFill];
            }
            [l.shape fill];
            [l.shape stroke];
        }
    }
    
    for (BUNRay * r in rays)
    {
        [[NSColor colorWithCalibratedHue:r.hue saturation:1 brightness:1 alpha:1] setStroke];
        [r computeRay];
        if (!(isnan(r.lightPath.bounds.size.width) ||
              isnan(r.lightPath.bounds.size.height) ||
              isnan(r.lightPath.bounds.origin.x) ||
              isnan(r.lightPath.bounds.origin.y)))
        {
            [r.lightPath stroke];
        }
    }
    
    [[NSColor yellowColor] set];
    [[NSBezierPath bezierPathWithOvalInRect:NSMakeRect(source.x-10, source.y-10, 20, 20)] fill];
    
    [[NSColor yellowColor] set];
    [[NSBezierPath bezierPathWithOvalInRect:NSMakeRect(target.x-5, target.y-5, 10, 10)] fill];
    
    [ctx restoreGraphicsState];
}


#pragma mark MOUSE EVENTS


-(void)mouseDown:(NSEvent *)theEvent
{
    [super mouseDown:theEvent];
    BOOL doubleClick = [theEvent clickCount]>1;
    
    NSPoint clic = [self convertPoint:theEvent.locationInWindow fromView:nil];
    clic.x = (clic.x-self.frame.size.width/2)/scale + self.frame.size.width/2;
    clic.y = (clic.y-self.frame.size.height/2)/scale + self.frame.size.height/2;
    
    BOOL didGetALens = NO;
    BUNLens * nextLens1;
    if (catchTarget == NO && catchSource == NO)
    {
        for (BUNLens * l in lenses)
        {
            if ([l containsPoint:clic])
            {
                didGetALens = YES;
                if (theEvent.type != NSLeftMouseDragged)
                {
                    if (l.selected == YES)
                    {
                        if (doubleClick)
                        {
                            l.selected = NO;
                            for (BUNLens * lll in lenses)
                            {
                                if (lll.selected == YES)
                                {
                                    nextLens1 = lll;
                                    break;
                                }
                            }
                        }
                        else
                        {
                            nextLens1 = l;
                        }
                    }
                    else
                    {
                        l.selected = YES;
                        nextLens1 = l;
                    }
                }
                else
                {
                    nextLens1 = self.lens1;
                }
            }
        }
        self.lens1 = nextLens1;
        [(AppDelegate*)[NSApp delegate] setUIWithLens:lens1];
    }
    
    
    NSRect sourceRect = NSMakeRect(source.x-20, source.y-20, 40, 40);
    NSRect targetRect = NSMakeRect(target.x-20, target.y-20, 40, 40);
    
    BOOL didGetAPoint = NO;
    if(NSPointInRect(clic, sourceRect) || catchSource)
    {
        source = clic;
        catchSource = YES;
        didGetAPoint = YES;
        [self updateRays];
    }
    else if(NSPointInRect(clic, targetRect) || catchTarget )
    {
        target = clic;
        catchTarget = YES;
        didGetAPoint = YES;
        [self updateRays];
    }
    
    if (didGetALens == NO && didGetAPoint == NO)
    {
        if (didGetAPoint == NO)
        {
            for (BUNLens * l in lenses)
            {
                l.selected = NO;
            }
        }
    }
    [self setNeedsDisplay:YES];
}

-(void)updateRays
{
    for (int i = 0 ; i< rays.count ; i++)
    {
        BUNRay  * r = [rays objectAtIndex:i];
        r.lenses = self.lenses;
        
        if (rayMode == 0)  // point à l'infini
        {
            [self setEcart:lastEc];
            r.startAngle =  [self angleFromX:source.x Y:source.y toX:target.x Y:target.y];
            r.startX = source.x + (-(double)rays.count/2 + (double)i +0.5)*ec*cos(r.startAngle + M_PI/2);
            r.startY = source.y + (-(double)rays.count/2 + (double)i+0.5)*ec*sin(r.startAngle + M_PI/2);
            r.hue = 0.5;
        }
        else if (rayMode == 1) // point
        {
            [self setEcart:lastEc];
            r.startAngle = [self angleFromX:source.x Y:source.y toX:target.x Y:target.y] +  M_PI/(5*(20-ec)) - ((double)i/(rays.count-1)) * M_PI/(2.5*(20-ec));
            r.startX = source.x;
            r.startY = source.y;
            
            r.hue = 0.5;
        }
        else if (rayMode == 2) // point à l'infini multicolore
        {
            double tmpEc = ec;
            [self setEcart:0];
            if(tmpEc != 0)
            {
                lastEc = tmpEc;
            }
            
            r.startAngle =  [self angleFromX:source.x Y:source.y toX:target.x Y:target.y];
            r.startX = source.x + (-(double)rays.count/2 + (double)i +0.5)*ec*cos(r.startAngle + M_PI/2);
            r.startY = source.y + (-(double)rays.count/2 + (double)i+0.5)*ec*sin(r.startAngle + M_PI/2);
            r.hue = (double)i/(1+(double)rays.count);
        }
        
        
        [r computeRay];
    }
}

-(void)mouseDragged:(NSEvent *)theEvent
{
    [super mouseDragged:theEvent];
    [self mouseDown:theEvent];
}

-(void)mouseUp:(NSEvent *)theEvent
{
    catchSource = NO;
    catchTarget = NO;
}


#pragma mark OTHER

-(void)setScale:(double)s
{
    scale = s;
}

-(void)setEcart:(double)ee
{
    lastEc = ee;
    ec = ee;
}

-(BOOL)acceptsFirstResponder
{
    return YES;
}


-(void)viewDidEndLiveResize
{
    //[self reset];
    for (BUNRay * r in rays)
    {
        r.startY = self.frame.size.height/2;
        [r computeRay];
    }
    for (BUNLens * l in lenses)
    {
        l.y = self.frame.size.height/2;
        [l makeShape];
    }
    [self setNeedsDisplay:YES];
}


-(double)distanceFromX1:(double)x1 Y1:(double)y1 ToX2:(double)x2 Y2:(double)y2
{
    return sqrt((x2-x1)*(x2-x1) + (y2-y1)*(y2-y1));
}


-(double)angleFromX:(double)x1 Y:(double)y1 toX:(double)x2 Y:(double)y2
{
    if (x1 == x2)
    {
        if (y1>y2)
        {
            return -M_PI/2;
        }
        else if(y2 >= y1)
        {
            return M_PI/2;
        }
    }
    else if (y1 == y2)
    {
        if (x1>x2)
        {
            return M_PI;
        }
        else if(x2>=x1)
        {
            return 0;
        }
    }
    return atan((y2-y1)/(x2-x1)) + M_PI*((x2-x1)<0);
}


@end
