//
//  BUNRay.m
//  Refraction
//
//  Created by minibun on 31/12/2015.
//  Copyright (c) 2015 minibun. All rights reserved.
//

#import "BUNRay.h"
#import "BUNLens.h"





@implementation BUNRay

@synthesize points, lenses, lightPath, startX, startY, startAngle;
@synthesize hue;
-(id)init
{
    self = [super init];
    if (self != nil)
    {
        self.points = [NSMutableArray array];
        self.lightPath = [NSBezierPath bezierPath];
        return self;
    }
    return nil;
}



-(void)computeRay
{
    self.lightPath = [NSBezierPath bezierPath];
    double x = startX;
    double y = startY;
    
    double a = [self coeffAWithAngle:self.startAngle];
    double b = [self coeffBWithAngle:self.startAngle andY:startY andX:startX];
    
    double curAngle = self.startAngle;
    [lightPath moveToPoint:NSMakePoint(startX, startY)];
    for (int i= 0; i<lenses.count; i++)
    {
        BUNLens * lens =  [lenses objectAtIndex:i];
        
        double ox = [lens ox1];
        double oy = [lens y];
        double or = [lens r1];
        
        double A = a*a + 1;
        double B = 2*a*b - 2*ox - 2*a*oy;
        double C = b*b - 2*b*oy + oy*oy + ox*ox - or*or;
        double D = sqrt(B*B - 4*A*C);
        if (isnan(D)  || [[NSNumber numberWithDouble:D] isEqualToNumber:[NSDecimalNumber notANumber]] )
        {
            //NSLog(@"D IS NAN");
            break;
        }
        
        if (or>=0)
        {
            x = (-B - D)/(2*A);
        }
        else
        {
            x = (-B + D)/(2*A);
        }
        y = a * x + b;

        if (isnan(x)  || [[NSNumber numberWithDouble:x] isEqualToNumber:[NSDecimalNumber notANumber]] ||
            isnan(y)  || [[NSNumber numberWithDouble:y] isEqualToNumber:[NSDecimalNumber notANumber]] )
        {
            //NSLog(@"x or y IS NAN");
            break;
        }
        [lightPath lineToPoint:NSMakePoint(x, y)];

        double normale = -(asin((y - lens.y)/or) );
        
        double i1 = normale - curAngle ;
        double i2 = asin(1.0 * sin(i1) / (lens.n+self.hue*lens.dispersion));
        
        curAngle = normale - i2;
        a = [self coeffAWithAngle:curAngle];
        b = [self coeffBWithAngle:curAngle andY:y andX:x];
        
         ox = [lens ox2];
         oy = [lens y];
         or = -[lens r2];
        
         A = a*a + 1;
         B = 2*a*b - 2*ox - 2*a*oy;
         C = b*b - 2*b*oy + oy*oy + ox*ox - or*or;
         D = sqrt(B*B - 4*A*C);
        
        if (isnan(D) || [[NSNumber numberWithDouble:D] isEqualToNumber:[NSDecimalNumber notANumber]])
        {
            //NSLog(@"D IS NAN 2");
            break;
        }
        
        
        if (or<0)
        {
            x = (-B - D)/(2*A);
        }
        else
        {
            x = (-B + D)/(2*A);
        }
         y = a * x + b;
        
        if (isnan(x)  || [[NSNumber numberWithDouble:x] isEqualToNumber:[NSDecimalNumber notANumber]] ||
            isnan(y)  || [[NSNumber numberWithDouble:y] isEqualToNumber:[NSDecimalNumber notANumber]] )
        {
            //NSLog(@"x or y IS NAN 2");
            break;
        }
        
        [lightPath lineToPoint:NSMakePoint(x, y)];
        normale = (asin((y - lens.y)/or) );
        
        i1 = normale - curAngle ;
        i2 = asin((lens.n+self.hue*lens.dispersion) * sin(i1) / 1.0);
        curAngle = normale - i2;
        
        a = [self coeffAWithAngle:curAngle];
        b = [self coeffBWithAngle:curAngle andY:y andX:x];
    }
    
    if (isnan(x)  || [[NSNumber numberWithDouble:x] isEqualToNumber:[NSDecimalNumber notANumber]] ||
        isnan(y)  || [[NSNumber numberWithDouble:y] isEqualToNumber:[NSDecimalNumber notANumber]] )
    {
        //NSLog(@"x or y IS NAN");
        return;
    }
    
    [lightPath lineToPoint:NSMakePoint(x+3000*cos(curAngle), y+3000*sin(curAngle))];
}


-(double)coeffAWithAngle:(double)a
{
    return tan(a);
}

-(double)coeffBWithAngle:(double)a andY:(double)y andX:(double)x
{
    return y - [self coeffAWithAngle:a]*x;
}


-(double)distanceFromX1:(double)x1 Y1:(double)y1 ToX2:(double)x2 Y2:(double)y2
{
    return sqrt((x2-x1)*(x2-x1) + (y2-y1)*(y2-y1));
}


-(double)angleFromX:(double)x1 Y:(double)y1 toX:(double)x2 Y:(double)y2
{
    if (x1 == x2)
    {
        if (y1>y2)
        {
            return -M_PI/2;
        }
        else if(y2 >= y1)
        {
            return M_PI/2;
        }
    }
    else if (y1 == y2)
    {
        if (x1>x2)
        {
            return M_PI;
        }
        else if(x2>=x1)
        {
            return 0;
        }
    }
    return atan((y2-y1)/(x2-x1)) + M_PI*((x2-x1)<0);
}

@end
