//
//  AppDelegate.m
//  Refraction
//
//  Created by minibun on 31/12/2015.
//  Copyright (c) 2015 minibun. All rights reserved.
//

#import "AppDelegate.h"
#import "BUNLens.h"
#import "BUNRay.h"



@implementation AppDelegate
@synthesize window;


-(BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)sender
{
    return YES;
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    //[[NSUserDefaults standardUserDefaults] removePersistentDomainForName:@"com.bunex-industries.Refraction"];
    
    [rayMode removeAllItems];
    [rayMode addItemsWithTitles:@[@"Point à l'infini",@"Point",@"Rayon multicolore"]];
    
    [view reset];
}

-(void)awakeFromNib
{
    
}

-(IBAction)duplicate:(id)sender
{
    BUNLens * ll = [view.lens1 copy];
    ll.x = [view.lenses.lastObject x] + 100;
    ll.selected = YES;
    [ll makeShape];
    [view.lenses addObject:ll];
    
    view.lens1.selected = NO;
    view.lens1 = ll;
    
    [self setUIWithLens:ll];
    [view setNeedsDisplay:YES];
    
}

-(IBAction)add:(id)sender
{
    for (BUNLens * ll in view.lenses)
    {
        ll.selected = NO;
    }
    BUNLens * lens11 = [[BUNLens alloc] init];
    lens11.r1 = 600;
    lens11.r2 = -600;
    lens11.x = [view.lenses.lastObject x] + 200;
    lens11.y = view.frame.size.height/2;
    lens11.h1 = 150;
    lens11.h2 = 150;
    lens11.ep = 30;
    lens11.n = 1.5;
    lens11.selected = YES;
    lens11.dispersion = 0.01;
    
    [lens11 makeShape];
    [view.lenses addObject:lens11];
    view.lens1 = lens11;
    view.lens1.selected = YES;
    
    [self setUIWithLens:lens11];
    [view setNeedsDisplay:YES];
}


-(IBAction)save:(id)sender
{
    NSData * data = [NSKeyedArchiver archivedDataWithRootObject:view.lenses];
    [[NSUserDefaults standardUserDefaults] setObject:data forKey:@"lenses"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

-(IBAction)saveAs:(id)sender
{
    NSData * data = [NSKeyedArchiver archivedDataWithRootObject:view.lenses];
    NSSavePanel * savepanel = [NSSavePanel savePanel];
    [savepanel setCanCreateDirectories:YES];
    if([savepanel runModal]==1)
    {
        [data writeToFile:[[savepanel URL] path] atomically:YES];
    }
    
}

-(IBAction)openLens:(id)sender
{
    NSOpenPanel * openPanel = [NSOpenPanel openPanel];
    [openPanel setCanChooseDirectories:NO];
    [openPanel setAllowsMultipleSelection:NO];
    if([openPanel runModal]==1)
    {
        NSData * data = [NSData dataWithContentsOfFile:[[openPanel URL] path]];
        view.lenses = [NSKeyedUnarchiver unarchiveObjectWithData:data];
        
        for (int i = 0 ; i < 5; i++)
        {
            BUNRay * ray = [view.rays objectAtIndex:i];
            ray.lenses = view.lenses;
        }
        [view setNeedsDisplay:YES];
    }
}

-(IBAction)remove:(id)sender
{
    if (view.lens1.selected)
    {
        [view.lenses removeObject:view.lens1];
        if (view.lenses.count)
        {
            view.lens1 = [view.lenses objectAtIndex:0];
            view.lens1.selected = YES;
            [self setUIWithLens:view.lens1];
        }
    }
    [view setNeedsDisplay:YES];
}


-(IBAction)sldrAction:(id)sender
{
    double sld1 = r1sld.doubleValue * (1 - 2*neg1.state);
    double sld2 = r2sld.doubleValue * (1 - 2*neg2.state);;
    
    view.lens1.r1 = sld1;
    view.lens1.r2 = sld2;
    


    
    view.lens1.h1 = h1sld.doubleValue;
    view.lens1.h2 = h2sld.doubleValue;
    
    if(ABS(sld1) < view.lens1.h1)
    {
        view.lens1.h1 = ABS(sld1) - 1;
    }
    if(ABS(sld2) < view.lens1.h2)
    {
        view.lens1.h2 = ABS(sld2) - 1;
    }
    
    view.lens1.ep = epsld.doubleValue;
    view.lens1.n = nsld.doubleValue;
    view.lens1.dispersion = dsld.doubleValue;
    
    [view.lens1 makeShape];
    
    [view setScale:scalesld.doubleValue];
    [view setEcart:ecartsld.doubleValue];
    
    [view updateRays];
    
    NSSortDescriptor * des = [NSSortDescriptor sortDescriptorWithKey:@"x" ascending:YES];
    [view.lenses sortUsingDescriptors:@[des]];
    [view setNeedsDisplay:YES];
}

-(IBAction)sldrXAction:(id)sender
{
    double tmpX = view.lens1.x;
    double deltaX = xsld.doubleValue - tmpX;
    
    for (int i = 0; i < view.lenses.count; i++)
    {
        BUNLens * l = [view.lenses objectAtIndex:i];
        if (l.selected == YES)
        {
            l.x = l.x + deltaX;
        }
        
        [l makeShape];
    }
    
    NSSortDescriptor * des = [NSSortDescriptor sortDescriptorWithKey:@"x" ascending:YES];
    [view.lenses sortUsingDescriptors:@[des]];
    [view setNeedsDisplay:YES];
}

-(IBAction)selectRayMode:(NSPopUpButton*)sender
{
    view.rayMode = (int)sender.indexOfSelectedItem;
    [view updateRays];
    [view setNeedsDisplay:YES];
}


-(void)setUIWithLens:(BUNLens*)l
{
    [r1sld setMinValue:l.h1/2];
    [r2sld setMinValue:l.h2/2];
    
    [r1sld setDoubleValue:ABS(l.r1)];
    [r2sld setDoubleValue:ABS(l.r2)];
    [neg1 setState:(l.r1<0)];
    [neg2 setState:(l.r2<0)];
    
    [epsld setDoubleValue:l.ep];
    [h1sld setDoubleValue:l.h1];
    [h2sld setDoubleValue:l.h2];
    [xsld setDoubleValue:l.x];
    [nsld setDoubleValue:l.n];
    [dsld setDoubleValue:l.dispersion];
    
}





@end
